/*

  File:    VLC.js
  
  Description:    JavaScript code; specifies Widget logic.
        
  Author:    glenbo - Glen Bowers - glenbo (AT) mac (DOT) com

  Copyright:  I consider this show-me-ware. You are more than welcome to use
  			  this code, just show me if you make any improvements to it.
        
  Change History (most recent first):
            04152005    glenbo      Initial version; core functionality

*/

	
if (window.widget) {
	widget.onhide = onhide;
	widget.onshow = onshow;
}


// startup()
//
// code to be run at startup. can call check4VLC to see if VLC is running
// currently unimplemented
function startup() {
}


// launchVLC()
//
// this will launch VLC if VLC is not currently running
// not currently implemented
function launchVLC() {
}


// check4VLC()
//
// this will check to see if VLC is running
// not currently implemented
function check4VLC() {	
}


// buttonPress()
//
// when a button is pressed, this gets called from mouseDown
// it sends a straight unix command with applescript to VLC
function buttonPress(VLC_Event) {
	var obj = widget.system("/usr/bin/osascript -e 'tell application \"VLC\"' -e \""+VLC_Event+"\" -e 'end tell' ", null);
}


// mouseDown()
//
// during a button press this will change the image to look like it is being pressed
// then call buttonPress
function mouseDown(event, id) {
	event.target.src = "Images/"+id+"_blue.png";
	buttonPress(id);
}


// mouseUp()
//
// after the user lets go of the button the image gets switched back to the off click button
function mouseUp(event, id) {
	event.target.src = "Images/"+id+".png";
}


// onshow()
//
// the code in this function is ran when the dashboard is revealed
// not currently implemented
function onshow () {
}


// onhide()
//
// the code in this function is ran when the dashboard is hidden
// not currently implemented
function onhide () {
}











